package service;


public abstract class ComposedState extends State {
	/** Create a new ComposedState
	 * If all the state of the array states are initial states, the composed state will be a initial state
	 * If all the state of the array states are final states, the composed state will be a final state
	 * @param name name that identifies the state
	 * @param states array of states that make up the ComposedState
	 */
	public ComposedState(String name,State[] states){
		super(name);		
	}
	
	public ComposedState(State[] states){
		super("");		
	}
	
	/** Returns if the current state is final or not.
	 * @return returns true if the state is final else return false
	 */
	public abstract boolean isFinal();
	/** Returns if the current state is a initial state.
	 * @return returns true if the state is a initials state else return false
	 */
	public abstract boolean isInitial();
	/** Returns the array of states that make up the ComposedState
	*/
	public abstract State[] getStates();
	/** Returns the state of the ComposedState identified by the serviceNumber
	*/
	public abstract State getServicesState(int serviceNumber) throws Exception;
	/**
	 * This method returns the hashCode of the state
	 * @return The string contains the hashCode of the state
	 */
	public int hashCode(){
		return super.hashCode();
	}
	/**
	 * This method compares a ComposedState with another object
	 * 
	 * @param obj the other object used by the comparison
	 * @return Return true if and only if obj is a ComposedState and the attributes of the two ComposedState are equals.
	 */
	public boolean equals(Object obj){
		return super.equals(obj);
	}
	/**
	 * Checks the number of substate that are different in each ComposedState
	 * 
	 * Warning: the compared states MUST be of the same dimension.
	 * E.g.: a={s1, s2, s5}
	 * b={s1, s3}
	 * a.compareNumberDifferentStates(b) will return -1
	 * @param state the state to compare
	 * @return an integer representing the number of different substates between the compared ComposedStates. Returns -1 in case of wrong comparison
	 */
	public abstract int compareNumberDifferentStates(ComposedState state);
	
}

